delete from EST_PROD_RC_CLI_CONV
where CD_PROD in (
                     select CD_PROD
                     from EST_PROD_RC_CLI_CONV
                     group by CD_PROD
                     having count(CD_PROD) > 1
                 );
go

if exists
(select * from sys.indexes where object_id = object_id(N'[dbo].[EST_PROD_RC_CLI_CONV]')
          and name = N'IX_EST_PROD_RC_CLI_CONV_FK' and is_unique=0
)
begin    
    drop index [IX_EST_PROD_RC_CLI_CONV_FK] on [EST_PROD_RC_CLI_CONV];

end
go

if not exists
(select * from sys.indexes 
	   where object_id = object_id(N'[dbo].[EST_PROD_RC_CLI_CONV]')
          and name = N'IX_EST_PROD_RC_CLI_CONV_FK' 
)
begin    

    alter table dbo.EST_PROD_RC_CLI_CONV
    add constraint IX_EST_PROD_RC_CLI_CONV_FK
	   unique nonclustered
	   (
		  CD_EMP
		, CD_PROD
	   )
	   with (statistics_norecompute = off, ignore_dup_key = off, allow_row_locks = on, allow_page_locks = on) on [PRIMARY];

  
end
go